document.addEventListener("DOMContentLoaded", function() {
    // Effet de scroll fluide sur la navigation
    const navLinks = document.querySelectorAll("nav ul li a");

    navLinks.forEach(link => {
        link.addEventListener("click", function(event) {
            event.preventDefault();
            const targetSection = document.querySelector(link.getAttribute("href"));
            targetSection.scrollIntoView({ behavior: "smooth", block: "start" });
        });
    });

    // Animation d'apparition au scroll
    const sections = document.querySelectorAll("section");

    function revealSections() {
        sections.forEach(section => {
            const sectionTop = section.getBoundingClientRect().top;
            const windowHeight = window.innerHeight;
            if (sectionTop < windowHeight - 100) {
                section.classList.add("visible");
            }
        });
    }

    window.addEventListener("scroll", revealSections);
    revealSections(); // Exécuter au chargement initial

    // Effet de zoom sur les projets
    const projects = document.querySelectorAll(".project");

    projects.forEach(project => {
        project.addEventListener("mouseenter", () => {
            project.style.transform = "scale(1.05)";
        });

        project.addEventListener("mouseleave", () => {
            project.style.transform = "scale(1)";
        });
    });

    // Effet sur le formulaire de contact
    const form = document.querySelector("form");

    form.addEventListener("submit", function(event) {
        event.preventDefault();
        alert("Merci pour votre message ! Je vous contacterai bientôt.");
        form.reset(); // Réinitialiser le formulaire après envoi
    });
});
